---
title: Cloudflare Network Analytics · Cloudflare Analytics docs
description: Cloudflare Network Analytics (version 2) provides near real-time
  visibility into network and transport-layer traffic patterns and DDoS attacks.
  Network Analytics visualizes packet and bit-level data, the same data
  available via the Network Analytics dataset of the GraphQL Analytics API.
lastUpdated: 2025-09-09T13:48:51.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/analytics/network-analytics/
  md: https://developers.cloudflare.com/analytics/network-analytics/index.md
---

Cloudflare Network Analytics (version 2) provides near real-time visibility into network and transport-layer traffic patterns and DDoS attacks. Network Analytics visualizes packet and bit-level data, the same data available via the Network Analytics dataset of the GraphQL Analytics API.

Requirements

Network Analytics requires the following:

* A Cloudflare Enterprise plan.
* Cloudflare Magic Transit or Spectrum.
* Cloudflare Magic WAN.

For a technical deep-dive into Network Analytics, refer to our [blog post](https://blog.cloudflare.com/building-network-analytics-v2/).

## Remarks

* The Network Analytics logs refer to IP traffic of Magic Transit customer prefixes/leased IP addresses or Spectrum applications. These logs are not directly associated with the [zones](https://developers.cloudflare.com/fundamentals/concepts/accounts-and-zones/#zones) in your Cloudflare account.

* The data retention for Network Analytics is 16 weeks. Additionally, data older than eight weeks might have lower resolution when using narrow time frames.

## Related resources

* [Cloudflare GraphQL API](https://developers.cloudflare.com/analytics/graphql-api/)
* [Cloudflare Logpush](https://developers.cloudflare.com/logs/logpush/)
* [Migrating from Network Analytics v1 to Network Analytics v2](https://developers.cloudflare.com/analytics/graphql-api/migration-guides/network-analytics-v2/)
