---
title: Settings by plan · Cloudflare Spectrum docs
description: Certain fields in Spectrum request and response bodies require an
  Enterprise plan. To upgrade your plan, contact your account team.
lastUpdated: 2025-08-18T14:27:42.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/spectrum/reference/settings-by-plan/
  md: https://developers.cloudflare.com/spectrum/reference/settings-by-plan/index.md
---

Certain fields in Spectrum request and response bodies require an Enterprise plan. To upgrade your plan, contact your account team.

Spectrum properties requiring an Enterprise plan:

| Name | Type | Description | Example |
| - | - | - | - |
| `origin_dns` | object | Method and parameters used to discover the origin server address via DNS. Valid record types are `A`, `AAAA`, `SRV` and empty (both `A` and `AAA`). A request must contain either an `origin_dns` parameter or an `origin_direct` parameter. When both are specified the service returns an `HTTP 400 Bad Request`. | `origin_dns: {type: A, name: mqtt.example.com, ttl: 1200}` |
| `origin_port` | integer | The destination port at the origin. | `22` |
| `proxy_protocol` | string | Enables Proxy Protocol to the origin. Spectrum supports `v1`, `v2`, and `simple` proxy protocols. Refer to [Proxy Protocol](https://developers.cloudflare.com/spectrum/how-to/enable-proxy-protocol/) for more details. | `off` |
| `ip_firewall` | boolean | Enables IP Access rules for this application. | `true` |
| `tls` | string | Type of TLS termination for the application. Options are `off` (default, also known as Passthrough), `flexible`, `full`, and `strict`. Refer to [Configuration Options](https://developers.cloudflare.com/spectrum/reference/configuration-options/) for descriptions of each. | `full` |
| `argo_smart_routing` | boolean | Enables Argo Smart Routing for the application. Note that it is only available for TCP applications with traffic\_type set to `direct`. | `true` |

Review the [Spectrum API documentation](https://developers.cloudflare.com/api/resources/spectrum/subresources/apps/methods/list/) for example API requests.
