---
title: Resources by selector · Cloudflare Style Guide
description: The ResourcesBySelector component allows you to pull in
  documentation resources based on the pcx_content_type, tags and products
  frontmatter properties.
lastUpdated: 2025-08-14T13:46:41.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/components/resources-by-selector/
  md: https://developers.cloudflare.com/style-guide/components/resources-by-selector/index.md
---

The `ResourcesBySelector` component allows you to pull in documentation resources based on the `pcx_content_type`, `tags` and `products` frontmatter properties.

## Component

### Inputs

* `directory` string

  The directory to search for resources in, relative to `src/content/docs/`. For example, for Workers tutorials, `directory="workers/tutorials/"`.

* `filterables` string\[]

  An array of frontmatter properties to show in the frontend filter dropdown. For example, `filterables={["tags"]}` will allow users to filter based on each pages' `tags` frontmatter.

* `types` string\[]

  An array of `pcx_content_type` values to filter which content gets pulled into the component. For example, `types={["example"]}`.

* `tags` string\[] optional

  An array of `tags` values to filter which content gets pulled into the component. For example, `tags={["AI"]}`.

  To see a list of the available tags, and which pages are associated with them, refer to [this list](https://developers.cloudflare.com/style-guide/frontmatter/tags/).

* `products` string\[] optional

  An array of `products` values to filter which content gets pulled into the component. For example, `products={["D1"]}`.

* `showDescriptions` boolean optional (default true)

  If set to `false`, will only show the titles of associated pages, not the showDescriptions

* `showLastUpdated` boolean optional (default false)

  If set to `true`, will add the last updated date, which is added in the [`updated` frontmatter value](https://developers.cloudflare.com/style-guide/frontmatter/custom-properties/#updated).
